#ifndef UTIL_H
#define	UTIL_H

// Misc functions to be called from main
#include <xc.h>
#include "io.h"
//making use of some features from backpack
#include "backpack.h"
#include "fonts.h"
#include "irrx.h"

#define VOL_0 (114)
#define VOL_M (217)
#define MASTER_MAX (200)
#define MASTER_MIN (-400)
#define DP_MAX (255)
#define MUTE_STEPS (20)
#define SAVE_TIME (148)
#define SETUP_COUNT (24)
#define SETUP_TIME (55)
#define IR_TELLTAME_TIME (9)
#define SW_FLAG_VALUE (0x33)
extern unsigned char doSetup;
extern unsigned char lastSetup;
extern unsigned char setupIndex;
extern volatile unsigned char counter;
extern volatile unsigned char saveCounter;
extern volatile unsigned char setupCtr;
extern struct backpackbutton button_up,button_down,button_mute,button_setup;
extern struct backpackbutton setup_p,setup_m,setup_next,setup_loadir;
extern unsigned char digits[5];
extern unsigned int xx;
extern int masterVol;    //tenths of a dB
extern int lastMasterVol;
extern int digipotVol;             //value sent to digipots
extern char updateFlag;
extern char muteState;
extern char lastMuteState;   //force ramp up conditions present at boot
extern char saveDone;
extern unsigned char slaveIN;
extern unsigned int colourSelect;
extern char codeSeen;
extern char irTelltale;
//non volatile in EEPROM, backed by variables in RAM and saved by timer
extern __eeprom char storedMuteState;
extern __eeprom int storedVol;
//these are used straight from EEPROM
typedef struct {
    int IRdevice;
    int IRdownButton;
    int IRupButton;
    int IRmuteButton;   
    int volMax;
    int slaveInUse;
    int dbOffset;   //in dB
    //int vol_0;    //per prototype, digipot setting for unit gain
    //int vol_m;    //per prototype, number of digipot steps for 25.6db change
    int chansInUse;
    int chanOffsets[20];
} eeprom_elements_t;

typedef union{
    eeprom_elements_t d;
    int e[28];
} eeprom_image_t;

extern __eeprom eeprom_image_t cur;
extern __eeprom char IRdevice;
extern __eeprom char IRdownButton;
extern __eeprom char IRupButton;
extern __eeprom char IRmuteButton;

extern const int setupMin[];
extern int setupMax[];
extern const char setupNames[][13];
extern const int dpSteps[];

void setDPchannels(int x,unsigned char n);    //set first n channels to x with respective offsets
void saveToEEPROM(void);
void flagSaveNeeded(void);
void changeMute(char m);
void editSetup(int n);
void showN(int n,unsigned int x, unsigned int y);       //reusable code to print a number
unsigned char sendSlave(unsigned char s);
unsigned char getStep(int g); //find step based on gain, ie inverse of dpSteps[]

#endif	/* UTIL_H */

